@extends('layouts.app')

@section('title', 'Register Doctor')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
        <h1 class="text-3xl font-bold text-gray-800">Register New Doctor</h1>
        <div class="flex gap-2">
            <a href="{{ route('admin.doctors') }}" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded">
                <i class="fas fa-arrow-left mr-2"></i>Back to Doctors
            </a>
            <a href="{{ route('admin.dashboard') }}" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded">
                <i class="fas fa-home mr-2"></i>Dashboard
            </a>
        </div>
    </div>

    @if($errors->any())
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <ul>
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form method="POST" action="{{ route('admin.doctors.store') }}" enctype="multipart/form-data" class="bg-white rounded-lg shadow p-6">
        @csrf

        <div class="mb-8">
            <h2 class="text-2xl font-bold mb-4">Personal Information</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Title</label>
                    <input type="text" name="title" value="{{ old('title') }}" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">First Name *</label>
                    <input type="text" name="first_name" value="{{ old('first_name') }}" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Last Name *</label>
                    <input type="text" name="last_name" value="{{ old('last_name') }}" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Email *</label>
                    <input type="email" name="email" value="{{ old('email') }}" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Phone</label>
                    <input type="text" name="phone" value="{{ old('phone') }}" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Country</label>
                    <input type="text" name="country" value="{{ old('country', 'Lesotho') }}" class="w-full px-3 py-2 border rounded">
                </div>
            </div>
        </div>

        <div class="mb-8">
            <h2 class="text-2xl font-bold mb-4">Professional Information</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Practice Number *</label>
                    <input type="text" name="practice_number" value="{{ old('practice_number') }}" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Specialization</label>
                    <input type="text" name="specialization" value="{{ old('specialization') }}" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Qualification</label>
                    <input type="text" name="qualification" value="{{ old('qualification') }}" class="w-full px-3 py-2 border rounded">
                </div>

                <div class="md:col-span-2">
                    <label class="block text-gray-700 text-sm font-bold mb-2">Educational Details</label>
                    <textarea name="educational_details" rows="3" class="w-full px-3 py-2 border rounded">{{ old('educational_details') }}</textarea>
                </div>
            </div>
        </div>

        <div class="mb-8">
            <h2 class="text-2xl font-bold mb-4">Account Information</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Password *</label>
                    <input type="password" name="password" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Confirm Password *</label>
                    <input type="password" name="password_confirmation" required class="w-full px-3 py-2 border rounded">
                </div>
            </div>
        </div>

        <div class="mb-8">
            <h2 class="text-2xl font-bold mb-4">Status</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="flex items-center">
                        <input type="checkbox" name="is_verified" value="1" {{ old('is_verified') ? 'checked' : '' }} class="mr-2">
                        <span class="text-gray-700 text-sm font-bold">Verified</span>
                    </label>
                </div>

                <div>
                    <label class="flex items-center">
                        <input type="checkbox" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }} class="mr-2">
                        <span class="text-gray-700 text-sm font-bold">Active</span>
                    </label>
                </div>
            </div>
        </div>

        <div class="mb-8">
            <h2 class="text-2xl font-bold mb-4">Upload Documents</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Profile Picture</label>
                    <input type="file" name="profile_picture" accept="image/*" class="w-full px-3 py-2 border rounded">
                    <p class="text-xs text-gray-500 mt-1">Optional - Max 2MB</p>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Letterhead</label>
                    <input type="file" name="letterhead" accept="image/*" class="w-full px-3 py-2 border rounded">
                    <p class="text-xs text-gray-500 mt-1">Optional - Max 2MB</p>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Stamp</label>
                    <input type="file" name="stamp" accept="image/*" class="w-full px-3 py-2 border rounded">
                    <p class="text-xs text-gray-500 mt-1">Optional - Max 2MB</p>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Signature</label>
                    <input type="file" name="signature" accept="image/*" class="w-full px-3 py-2 border rounded">
                    <p class="text-xs text-gray-500 mt-1">Optional - Max 2MB</p>
                </div>
            </div>
        </div>

        <div class="flex justify-end">
            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded">
                Register Doctor
            </button>
        </div>
    </form>
</div>
@endsection

